function [logL, theta, derivatives]=EstimTDVine(data,initialparams,optimizer)
% Estimate parameters and derivatives (numerically evaluated) of a
% D vine, assuming static T Copula for all pairs.

% This function  estimates the parameters of the D-Vine and is much
% slower than the EstimateTCanonicalVine.m. 
% If you want to calculate the derivatives (grad - hessian) use fminunc,
% instead of fmincon
% INPUTS
% data:             Matrix with U(0,1) or iid margins
% initialparams:    Initial values (use the estimates from EstimateTDVine.m
%                   to save time). It should be a column vector with
%                   N(N-1)/2 rows
% optimizer:        String with values 'fminunc' or 'fmincon'
% OUTPUT
% logL:             The log likelihood at the optimum
% theta:            The degree of freedom parameters
% derivatives:      A structure that contains the grad and hessian of the
%                   likelihood function at the optimum (if you choose
%                   fminunc)
% ------------------------------------------------------------------------
% Author: Manthos Vogiatzoglou, UoM, 2008 - 2009
% contact at: vogia@yahoo.com
%-------------------------------------------------------------------------
tic
display('----------------------------------------------------------------')
display('this function is very slow!')
display('----------------------------------------------------------------')
display('if you do not care about std errors run EstimateTDVine.m instead')
display('----------------------------------------------------------------')
[T,N]=size(data);
options = optimset('Display','iter','MaxFunEvals',10000,'TolCon',10^-10,'TolFun',10^-3,'TolX',10^-3);
if strcmp(optimizer,'fminunc')
    if isempty(initialparams)
    initialparams=crIPmat(3*ones(N*(N-1)/2,1));
    end
    [theta, likhood,exitflag,output,grad,hessian]= fminunc('TCopDVineLL',initialparams,options,data,optimizer);
    logL = -likhood;
    derivatives.grad=grad;
    derivatives.hessian=hessian;
elseif strcmp(optimizer,'fmincon')
    if isempty(initialparams)
    initialparams=crIPmat(30*ones(N*(N-1)/2,1));
    end
    lower=2.01*ones(N-1,N-1);
    upper=200*ones(N-1,N-1);
    [theta, likhood]= fmincon('TCopDVineLL',initialparams,[],[],[],[],lower,upper,[],options,data,optimizer);
    logL = -likhood;
    derivatives=[];
end
toc